;This program is used in PIC MCU Programming for Biginners chapter 9.  There is 
;no circuit or hardware for this execise however the reader my elect to wire
;some LEDs to the I/O pins as an indicator of delays.  The program uses
;the stop watch to explore the delay routines.



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count					;variable used in delay subroutines
	tempa
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF       ; retrieve factory calibration value
	movlw	OSCCAL					
	BANKSEL	Bank0		;select bank0
	movlw	b'00000000'
	movwf	PORTA		;clear port bus
	movlw	b'00000000'
	movwf	PORTC
	movlw	b'00000111'	;turn off comparator module
	movwf	CMCON		;
	movlw	b'00000000'	;interrupts all off
	movwf	INTCON
	movlw	b'10010001'	;right justified,Vdd ref RC0 has ADC, ADC Stop, ADC on
	movwf	ADCON0
	BANKSEL	Bank1		; BANK1
	movlw	b'00000000'	;enabling weak pull-ups 
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00010000'	;Fosc/8
	movwf	ADCON1
	movlw	b'00000000'	;all output 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;no weak pull-ups
	movwf	WPUA		
	movlw	b'00000000'	;all PORTC as outputs
	movwf	TRISC		;program PORTC
	movlw	b'00000000'	;all pins digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
	
;end MCU initialization
;*****************************************************************************



;main program
main
	nop
	call	delay1mS
	nop
	goto	main			;do it again

;*****************************************************************************

;******************************************************************************
;Delay Routines
;******************************************************************************
;more delay options than needed, this is standard delay code I use in other programs
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, f
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

bitdelay
		movlw	.31
		movwf	count
		goto    $+1
       
bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines
;***********************************************************************

	end
